import org.serviio.library.metadata.*
import org.serviio.library.online.*
import org.serviio.util.*
import java.util.regex.*
import java.text.*

/**
 * WebResource extractor plugin for Walla - nick and nickjr
 * 
 * @author iplem
 * V2 7/1/2012
 *
 * Based on previous Serviio Castalba plugin 
 *
 */
class Walla extends WebResourceUrlExtractor
{

	final String VALID_FEED_URL = '^http(s)?://(.*?)\\.walla\\.co\\.il/\\?w=//(\\d+)$'
	//final String HTML_SECTION = '(?s)</h1>(.*?)class="p_'
	final String HTML_SECTION  = '(?s)</h1\\s?>(.*?)wp-0-b footerNav'
	final String TITLE_SECTION = '(?s)<title>(.*?)</title>'
	final String VIDEO_SECTION = '(?s).*?src="(.*?)".*?src="(.*?)".*?a href="(.*?)"\\s*?>(.*?)</a>'

	String getExtractorName()
	{
		return 'Walla'
	}

	Boolean URLExists(URL fileURL)
	{
		return ((HttpURLConnection) fileURL.openConnection()).getResponseCode() != 404
	}

	boolean extractorMatches(URL feedUrl)
	{
		return feedUrl ==~ VALID_FEED_URL
	}

	WebResourceContainer extractItems(URL resourceUrl, int maxItems)
	{
		Matcher httpMatcher = resourceUrl.toString() =~ VALID_FEED_URL

		String maskUrl = "http://" + httpMatcher[0][2] + ".walla.co.il/?w=//" + httpMatcher[0][3] +"&page="
		List<WebResourceItem> items = []

		Integer itemsAdded = 0
		Integer pageCounter = 1
		String pageTitle
		String pageThumb

		while (true) {

			String html = readHebrewCodedPage(maskUrl + pageCounter)
			if (html == null || html.trim().length() == 0) {
				//println "No items - returning"
				break
			}

			if (pageTitle == null) {
				Matcher titleMatcher = html =~ TITLE_SECTION
				pageTitle = titleMatcher[0][1].trim()
				pageThumb = "http://isc.walla.co.il/w9/t/walla.gif"
			}

			Matcher pageMatcher = html =~ HTML_SECTION
			if (pageMatcher == null || pageMatcher.size() == 0) {
				//println "No items - returning"
				break
			}

			String page = pageMatcher[0][1]
			if (page.size() < 100) {
				//println "No items - returning"
				break
			}

			Matcher videoMatcher = page =~ VIDEO_SECTION
			for (Integer i = 0; i < videoMatcher.size() && (maxItems == -1 || itemsAdded < maxItems) ; i++ )
			{
				String videoTitle //= videoMatcher[i][4].trim()
				String linkUrl = "http://nick.walla.co.il/" + videoMatcher[i][3].trim() + "/@@/video/flv_pl&discardAds=1"
				String secCode

				groovy.util.Node linkXml
				try {
					linkXml = new groovy.util.XmlParser(false, false).parse(linkUrl)
					
					secCode = linkXml['items'][0]['item'][0]['src'][0].text()
					String rtmpUrl = "rtmp://wafla.walla.co.il app=vod playpath=" + secCode
					String thumbUrl = linkXml['items'][0]['item'][0]['preview_pic'][0].text()
					
					try {
						Date standardPubDate = new SimpleDateFormat("d_M_yyyy_H_m").parse(linkXml['items'][0]['item'][0]['release_date'][0].text())
						if (standardPubDate == null || standardPubDate.toString().size() == 0) {
							throw new IllegalArgumentException()
						}
						String pubDate
						try {
							Locale locale = new Locale('iw', 'IL')
							pubDate = ' - ' + DateFormat.getDateInstance(DateFormat.MEDIUM, locale).format(standardPubDate)
						} catch (e) {
							pubDate = ' - ' + new SimpleDateFormat("dd/mm/yyyy").format(standardPubDate)
						}

						videoTitle = linkXml['items'][0]['item'][0]['title'][0].text() + pubDate
					} catch (e) {
						videoTitle = linkXml['items'][0]['item'][0]['title'][0].text()
					}

					/* if (videoMatcher[i][2].trim() =~ "gif")
					 {
					 thumbUrl = videoMatcher[i][1].trim()
					 } else {
					 thumbUrl = videoMatcher[i][2].trim()
					 } */

					log("ADDED $videoTitle - $linkUrl")

					WebResourceItem item = new WebResourceItem(title: videoTitle, additionalInfo: ['resourceUrl':resourceUrl,'secCode':secCode,'rtmpUrl':rtmpUrl,'thumbUrl':thumbUrl])
					items << item

					itemsAdded++
				} catch (e) {
					log('error xml parser for secCode: ' +  e.getMessage() + '\n' + e.toString() + '\n' + e.getStackTrace().toString())
				}

			}

			pageCounter++

		}

		return new WebResourceContainer(title: pageTitle, thumbnailUrl: pageThumb, items: items)
	}
	

	private String readHebrewCodedPage(String pageUrl) {
		try {
			return new java.util.Scanner((InputStream)new URL(pageUrl).openConnection().getContent(), 'Cp1255').useDelimiter("\\A").next()
		} catch (e) {
			return null
		}
	}

	ContentURLContainer extractUrl(WebResourceItem item, PreferredQuality requestedQuality)
	{
		String videoUrl = item.getAdditionalInfo()['rtmpUrl']
		assert videoUrl != null
		String thumbnailUrl = item.getAdditionalInfo()['thumbUrl']
		assert thumbnailUrl != null
		String resourceUrl = item.getAdditionalInfo()['resourceUrl']
		def cacheKey = resourceUrl + "_" +  item.getAdditionalInfo()['secCode']

		return new ContentURLContainer(fileType: MediaFileType.VIDEO, contentUrl: videoUrl, thumbnailUrl: thumbnailUrl, live: true, cacheKey: cacheKey)
	}

	static void main(args)
	{
		Walla extractor = new Walla()
		assert extractor.extractorMatches( new URL("http://nickjr.walla.co.il/?w=//1688310") )
		assert !extractor.extractorMatches( new URL("http://google.com/feeds/api/standardfeeds/top_rated?time=today") )
		WebResourceContainer container = extractor.extractItems( new URL("http://nickjr.walla.co.il/?w=//1688310"), -1)
		ContentURLContainer result = extractor.extractUrl(container.getItems()[1], PreferredQuality.MEDIUM)
		//print result
	}
}